/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.commands.commands;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.commands.Command;
import Krasnodar.rockstarnew.systems.commands.CommandBuilder;
import Krasnodar.rockstarnew.systems.commands.CommandContext;
import Krasnodar.rockstarnew.systems.commands.CommandRegistry;
import Krasnodar.rockstarnew.systems.commands.ValidationResult;
import Krasnodar.rockstarnew.systems.localization.Localizator;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import net.minecraft.class_2561;
import ru.kotopushka.compiler.sdk.annotations.Compile;

public class PrefixCommand {
    @Compile
    public Command command() {
        return CommandBuilder.begin("prefix", b -> b.desc("commands.prefix.description").param("action", p -> p.optional().literal("list", "clear", "default", "set", "create")).param("new", p -> p.optional().validator(text -> (ValidationResult)((Object)(text.length() > 1 ? ValidationResult.error(Localizator.translate("commands.prefix.invalid_length")) : ValidationResult.ok(text))))).handler(this::handle)).build();
    }

    @Compile
    private void handle(CommandContext ctx) {
        String action = (String)ctx.arguments().get(0);
        String newPrefix = (String)ctx.arguments().get(1);
        CommandRegistry registry = Rockstar.getInstance().getCommandManager();
        String current = registry.getPrefix();
        if (action == null) {
            MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.prefix.current", current)));
        } else {
            String var6;
            switch (var6 = action.toLowerCase()) {
                case "list": {
                    MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.prefix.current", current)));
                    break;
                }
                case "clear": 
                case "default": 
                case "reset": {
                    registry.setPrefix(".");
                    MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.prefix.reset")));
                    break;
                }
                case "set": 
                case "create": {
                    if (newPrefix == null || newPrefix.isEmpty()) {
                        MessageUtility.error(class_2561.method_30163((String)Localizator.translate("commands.prefix.empty")));
                        return;
                    }
                    registry.setPrefix(newPrefix);
                    MessageUtility.info(class_2561.method_30163((String)Localizator.translate("commands.prefix.set", newPrefix)));
                }
            }
        }
    }
}

